# 画面設計書 4-グローバル404ページ (Global Not Found)

## 概要

App Routerにおいてルートレベルで一致するページが存在しない場合に表示されるデフォルトの404ページの設計書。完全なHTMLページ構造（html/bodyタグ）を含む。

### 本画面の処理概要

**業務上の目的・背景**：App Routerを使用するNext.jsアプリケーションにおいて、リクエストされたURLに対応するルートが全く見つからない場合（ルートレベルでの不一致）、ユーザーに対して「404: This page could not be found.」メッセージを表示する必要がある。本コンポーネントは、その最上位レベルの404フォールバックとして機能する。セグメントレベルの404（No.5の`not-found`）とは異なり、完全なHTMLページとしてレンダリングされ、html/bodyタグを含む独立したページを構成する。

**画面へのアクセス方法**：ユーザーが存在しないURLにアクセスした際に、App Routerのルーティング機構がルートレベルで一致するページを見つけられなかった場合に自動的に表示される。ユーザーがカスタムの`app/not-found.tsx`を作成している場合はそちらが優先される。

**主要な操作・処理内容**：
1. `<html>`および`<body>`タグを含む完全なHTML構造をレンダリングする
2. `HTTPAccessErrorFallback`コンポーネントにstatus=404とmessage="This page could not be found."を渡して表示する
3. HTTPAccessErrorFallbackコンポーネントが、ステータスコードとメッセージを中央配置で表示し、ダークモード対応のCSSを適用する

**画面遷移**：
- 遷移元：App Routerのルーティング処理でルートが見つからなかった場合に表示
- 遷移先：特になし（エラー表示のみ）

**権限による表示制御**：権限による表示制御は行わない。全ユーザーに対して同一の404表示を行う。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | エラーハンドリング | 主機能 | ルートレベルで一致するページが存在しない場合の404エラー表示処理 |
| 13 | App Router | 補助機能 | App Routerのルーティング機構を通じてグローバルNot Foundページを表示 |

## 画面種別

エラー表示（404フォールバック）

## URL/ルーティング

App Routerのルーティング処理でルートが見つからなかった際に自動表示。リクエストされたURLのまま404ステータスで表示される。

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| なし | - | - | - | 本コンポーネントはプロパティを受け取らない |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| ステータスコード | h1要素（左側） | 「404」を表示 |
| エラーメッセージ | h2要素（右側） | 「This page could not be found.」を表示 |
| ページタイトル | titleタグ | 「404: This page could not be found.」 |

## イベント仕様

### 1-なし

本画面にはユーザー操作可能なインタラクティブ要素は存在しない。表示のみの静的なエラーページである。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 本画面はデータベースへのアクセスを行わない |

### テーブル別更新項目詳細

データベース操作なし。

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|----------------|
| MSG-404 | エラー | 常時表示 | This page could not be found. |

## 例外処理

| 例外条件 | 挙動 |
|----------|------|
| なし | 本コンポーネントは常に同一の404エラーページを表示する。例外処理は不要。 |

## 備考

- App Routerで使用される。Pages Routerでは`_error.tsx`（No.1）が使用される
- ユーザーがルートレベルの`app/not-found.tsx`を作成することでカスタマイズ可能
- セグメントレベルのNot Found（No.5）とは異なり、html/bodyタグを含む完全なページ構造を持つ
- `HTTPAccessErrorFallback`コンポーネントを共有しており、403ページ（No.8）、401ページ（No.9）と同じ表示パターンを使用
- ダークモード対応は`prefers-color-scheme: dark`メディアクエリで自動適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本コンポーネントはプロパティを受け取らないシンプルな構成。HTTPAccessErrorFallbackに渡すstatus/messageのみが主要なデータ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | L3-8: HTTPAccessErrorFallbackのプロパティ型（status: number, message: string） |

**読解のコツ**: HTTPAccessErrorFallbackはstatus（数値）とmessage（文字列）の2つのプロパティのみを受け取るシンプルなコンポーネント。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | global-not-found.tsx | `packages/next/src/client/components/builtin/global-not-found.tsx` | L1-16: GlobalNotFound関数コンポーネント全体 |

**主要処理フロー**:
1. **L3**: `GlobalNotFound`関数コンポーネントの定義
2. **L5-6**: `<html>`と`<body>`タグで完全なHTMLページ構造を構成
3. **L7-9**: `HTTPAccessErrorFallback`にstatus=404とmessage="This page could not be found."を渡す

#### Step 3: HTTPAccessErrorFallbackコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | L3-45: HTTPAccessErrorFallback - ステータスコードとメッセージの表示 |
| 3-2 | access-error-styles.ts | `packages/next/src/client/components/styles/access-error-styles.ts` | L1-34: スタイル定義 - Flexbox中央配置レイアウト |

**主要処理フロー**:
- **L13**: `<title>`タグに「{status}: {message}」形式でページタイトルを設定
- **L15-43**: 画面中央にステータスコード（h1）とメッセージ（h2）を表示
- **L17-33**: インラインCSSでダークモード対応スタイルを適用

### プログラム呼び出し階層図

```
App Router (ルート不一致検出)
    |
    +-- GlobalNotFound コンポーネント
            |
            +-- <html>
            +-- <body>
                    |
                    +-- HTTPAccessErrorFallback
                            |
                            +-- status=404, message="This page could not be found."
                            +-- access-error-styles (CSS)
                            +-- ダークモードCSS (inline)
```

### データフロー図

```
[入力]               [処理]                           [出力]

(なし) -----------> GlobalNotFound() -----------> HTML構造
                    |                              - <html>
                    +-- HTTPAccessErrorFallback     - <title> "404: This page..."
                        (status=404,               - <h1> "404"
                         message="This page...")   - <h2> "This page could..."
                                                   - inline CSS (dark mode)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| global-not-found.tsx | `packages/next/src/client/components/builtin/global-not-found.tsx` | ソース | グローバル404ページのメインコンポーネント |
| error-fallback.tsx | `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` | ソース | HTTP Access Errorのフォールバック表示コンポーネント |
| access-error-styles.ts | `packages/next/src/client/components/styles/access-error-styles.ts` | ソース | Access Errorページの共通スタイル定義 |
